var panelDrawer = {};
function drawPanel(panel, context, textureWidth, textureHeight, fillStyle)
{
    context.fillStyle = fillStyle; 
    context.beginPath();
    context.moveTo(panel.P00.X * textureWidth, (1.0 - panel.P00.Y) * textureHeight);
    context.lineTo(panel.P10.X * textureWidth, (1.0 - panel.P10.Y) * textureHeight);
    context.lineTo(panel.P11.X * textureWidth, (1.0 - panel.P11.Y) * textureHeight);
    context.lineTo(panel.P01.X * textureWidth, (1.0 - panel.P01.Y) * textureHeight);
    context.closePath();
    context.fill();
};

panelDrawer.drawPanels = function(panels, count, canvas, drawPanelSilhouette)
{
    return this.drawPanelsOnContext
    (
        panels,
        count,
        canvas.getContext("2d"),
        canvas.width,
        canvas.height,
        drawPanelSilhouette
    );
}

panelDrawer.drawPanelsOnContext = function(panels, count, context, imageWidth, imageHeight, drawPanelSilhouette)
{
    for (var i = 0; i < count; i++)
    {
        drawPanel(panels[i], context, imageWidth, imageHeight, 'rgba(29, 29, 29, 1)');
    }

    if (drawPanelSilhouette)
    {
        for (var i = count; i < panels.length; i++)
        {
            drawPanel(panels[i], context, imageWidth, imageHeight, 'rgba(29, 29, 29, 0.3)');
        }
    }

    return context.canvas.toDataURL();
}

panelDrawer.drawCircumference = function(panels, count, segments)
{
    
}

if (typeof module !== 'undefined')
{
    module.exports = panelDrawer;
}
